<?php

namespace Sendcrux\Library;

use Illuminate\Database\Capsule\Manager as DB;

class WpHelper
{
    public static function getUserMetaFields()
    {
        $result = DB::select('SELECT DISTINCT meta_key FROM wp_usermeta');
        $fields = [];
        foreach ($result as $r) {
            $fields = array_merge($fields, array_values(get_object_vars($r)));
        }

        $additionalFields = self::getUserFields();

        return array_merge($additionalFields, $fields);
    }

    public static function getUserFields()
    {
        return [
            'ID',
            'user_login',
            'user_pass',
            'user_nicename',
            'user_email',
            'user_url',
            'user_registered',
            'user_activation_key',
            'user_status',
            'display_name'
        ];
    }

    public static function base_dir()
    {
        return WP_CONTENT_DIR . '/plugins/sendcrux-connect/';
    }

    public static function cronjob_path()
    {
        // return self::base_dir() . "run.php";
        $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
        return ' '.$actual_link ."/wp-content/plugins/sendcrux-connect/run.php";
    }
}
