var ConnectionEdit = {
    validate: function() {
        self = this;
        var errors = [];
        config = {
            modules : 'location, date, security, file',
            borderColorOnError: '',
            errorElementClass: null,
            inputParentClassOnError: 'form-invalid',
            validateHiddenInputs: true,
            onElementValidate : function(valid, element, $form, errorMess) {
                if (!valid) {
                    errors.push(element);
                }
            }
        }
        // Before commit validation
        $('#campaign1, #campaign2').isValid(null, config, true);

        return errors;
    },

    showNextStep: function(element) {
        element.removeClass('step-visible').addClass('step-disabled');
        element.next().addClass('step-visible');
        this.removeProgressBar(element);
    },
    
    wait4NextStep: function(element) {
        $('<div id="progressContainer"><p>Loading...</p><div id="progress"></div></div>').insertAfter(element.next());
        var bar = new ProgressBar.Line('#progress', {easing: 'easeInOut', duration: 3000, color: '#0073AA'});
        bar.animate(1);  // Value from 0.0 to 1.0
    },
    
    removeProgressBar: function(element) {
        element.next().next().remove(); // remove the progress bar
    },

    editStep: function(element) {
        element.removeClass('step-disabled').addClass('step-visible');

        next = element.next();
        while (true) {
            next.removeClass('step-visible').removeClass('step-disabled');

            if (next.next('div.step').length == 1) {
                next = next.next('div.step');
            } else {
                break;
            }
        }

    },

    init: function() {
        var self = this;

        // set click event on tab panels
        $("h3.nav-tab-wrapper > a.nav-tab").click(function(event, element) {
            self.showTab(this);
            return false;
        });

        $('div.step').on('click', '#connect', function(event) {
            event.preventDefault();
            self.wait4NextStep($(event.delegateTarget));
            self.api.connect({success: function(response) {
                $('#mailLists').html('');
                $.each(response.data, function(i, list) {
                    $('#mailLists').append(
                      $('<label/>')
                        .append($("<input/>", {edit: 1, type: 'radio', name: 'mail-list-id[]', value: list.uid, 'list-name': list.name}))
                        .append(' ' + list.name)
                    );
                });

                self.showNextStep($(event.delegateTarget));
            }, failed: function(response) {
                self.removeProgressBar($(event.delegateTarget));
                alert('Error while connecting to remote server!');
            }});
        });

        $('div.step').on('click', '#chooseList', function(event) {
            event.preventDefault();
            self.api.getListDetails({
                start: function() { self.wait4NextStep($(event.delegateTarget)); },
                success: function($response) {
                    self.showNextStep($(event.delegateTarget));
            }});
        });

        $('div.step').on('click', '#saveMapping', function(event) {
            event.preventDefault();
            if ($('input[name="sendcrux-fields[]"]:checked').length == 0) {
                alert('Please select at least one field');
                return false;
            }

            if ($('input[name="sendcrux-fields[]"][value="EMAIL"]:checked').length == 0) {
                alert('Email field must be selected');
                return false;
            }

            self.api.saveFieldsMapping();
            self.showNextStep($(event.delegateTarget));
        });

        $('div.step').on('click', '#saveFinish', function(event) {
            event.preventDefault();
            self.api.save();
        });

        $('div.step').on('click', '#editConnect', function(event) {
            event.preventDefault();
            self.editStep($(event.delegateTarget));
        });

        $('div.step').on('click', '#editList', function(event) {
            event.preventDefault();
            self.editStep($(event.delegateTarget));
        });

        $('div.step').on('click', '#editMapping', function(event) {
            event.preventDefault();
            self.editStep($(event.delegateTarget));
        });

        return true;

        // Init inline editor
        $.fn.editable.defaults.mode = 'inline';

        // Set editable element
        $('#campaign-send-on').editable({
            url: null,
            format: 'yyyy-mm-dd',
            viewformat: 'yyyy-mm-dd',
            showbuttons: true,
            datetimepicker: {
                weekStart: 1
            }
        });

        // Set editable element
        $('#campaign-send-at').editable({
            url: null,
            emptytext: 'unknown'
        });

        // Set default date/time for campaign schedule
        $('#campaign-send-on').text(moment().format('YYYY-MM-DD'));
        $('#campaign-send-at').text(moment().format('HH:mm'));

        $('#campaign-save-send').click(function(){
            errors = self.validate();
        });

        // extend validator for Campaign schedule
        $.formUtils.addValidator({
            name : 'campaign_schedule',
            validatorFunction : function(value, $el, config, language, $form) {
                var name = $el.attr('name');
                var selected = $("input[name='" + name + "']:checked");
                if (selected.length == 0){
                    return false;
                }

                if (selected.val() == 'later-on') {
                    send_on = $.trim($('#campaign-send-on').text());
                    send_at = $.trim($('#campaign-send-at').text());
                    if (/[0-9]{4}-[0-9]{2}-[0-9]{2}/.test(send_on) && /[0-9]{2}:[0-9]{2}/.test(send_at) ) {
                        //return true;
                    } else {
                        return false;
                    }
                }

                return true;
            },
            errorMessage : 'Please select the date and time for sending your campaign',
            errorMessageKey: 'badEvenNumber'
        });

        // Init form validation
        // Runtime validation
        $.validate({
            modules : 'location, date, security, file',
            borderColorOnError: '',
            errorElementClass: null,
            inputParentClassOnError: 'form-invalid',
            validateHiddenInputs: true
        });
    },

    api: {
        /* connect to Sendcrux Mail server, also fetch the mail lists */
        connect: function(callback) {
            self = this;

            params = {
                'sendcrux-endpoint': $('#sendcrux-endpoint').val(),
                'sendcrux-api-key': $('#sendcrux-api-key').val(),
            };

            $.ajax({
                'url': '/sendcrux/mail_list/connect',
                'method': 'post',
                'data': params
            }).done(function(response) {
                if (response.status == 'ok') {
                    if (response.data == null) {
                        alert('Invalid API key');
                    } else {
                        callback.success(response);
                    }
                } else {
                    callback.failed(response);
                }
            });
            return params;
        },

        getListDetails: function(callback) {
            self = this;

            selected = $("input[name='mail-list-id[]']:checked"). val();

            if (!selected) {
                alert("Please select a mail list");
                return false;
            }

            $('#fields').html('');
            callback.start();
            $.ajax({
                'url': '/sendcrux/mail_list/get/' + selected,
                'method': 'get',
            }).done(function(response) {
                if (response.status == 'ok') {
                    callback.success(response); // @todo
                    //alert(response.list.name);
                    $.each(response.list.fields, function(i,field) {
                        wpCustomFields = $('<select/>', { for: field.tag, name: 'wp-fields', edit: 1 });
                        $.each(response.wpFields, function(i, r) {
                            wpCustomFields.append($('<option/>', {value: r}).append(r));
                        });

                        $('#fields').append(
                          $('<tr/>')
                            .append($("<td/>").append($('<label/>').append($('<input>', {type: 'checkbox', value: field.tag, name: 'sendcrux-fields[]', checked: true, edit: 1 })).append(field.label) ) )
                            .append($("<td/>").append(wpCustomFields))
                        );

                        // toggle the dropdown list accordingly to the checkboxes
                        $('input[name="sendcrux-fields[]"]').click(function(e) { $('select[name="wp-fields"][for="' + this.value + '"]').attr('disabled', !this.checked); });
                    });
                } else {
                    self.showServerError(response.error);
                }
            });
            return params;
        },

        getWPCustomFields: function() {
            return ['name', 'age'];
        },

        saveFieldsMapping: function() {
            mapping = $('input[name="sendcrux-fields[]"]:checked').map( function () { f = $('select[for="' + this.value + '"][name="wp-fields"]').find(':selected').text(); return { 'wp-field': f, 'sendcrux-field': this.value}; }  ).get();
            console.log(mapping);
        },

        save: function() {
            params = {
                endpoint: $('#sendcrux-endpoint').val(),
                api_key: $('#sendcrux-api-key').val(),
                settings: {
                    mail_list_uid: $('[name="mail-list-id[]"]:checked').val(),
                    mail_list_name: $('[name="mail-list-id[]"]:checked').attr('list-name'),
                    mapping: $('input[name="sendcrux-fields[]"]:checked').map( function () { f = $('select[for="' + this.value + '"][name="wp-fields"]').find(':selected').text(); return { 'wp-field': f, 'sendcrux-field': this.value}; }  ).get()
                }
            }

            $.ajax({
                'url': '/sendcrux/mail_list/save',
                'method': 'post',
                'data': params
            }).done(function(data) {
                if (data.status == 'ok') {
                    window.location.href = $('meta[name="connection-index"]').attr('value');
                } else {
                    self.showServerError(data.error);
                }
            });
        }
    },

    showServerError: function(msg) {
        alert(msg);
    },

    showFormError: function() {
        $('body, html').animate({ scrollTop: 0 }, 800);
        $('#message').show();
    },
};

// Initialize the script
$(document).ready(function() {
    ConnectionEdit.init();
});
