<?php

define('SERVER_PROTOCOL', 'HTTP');

ini_set('display_errors',0);

@include('../../../wp-config.php');

// call the WP functions and stuff, according to the parameters
#require_once __DIR__ . '/vendor/autoload.php';
#require_once __DIR__ . '/vendor/getherbert/framework/bootstrap/autoload.php';

use Sendcrux\Library\Log as SendcruxLog;
use Sendcrux\Library\WpHelper;
use Sendcrux\Models\Job;

SendcruxLog::configure(WpHelper::base_dir() . "log/app.log");

// SendcruxLog::info('Starting...');
$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
if (false === $socket) {
    SendcruxLog::error("Can't create socket: ".socket_last_error($socket));
    exit;
}

// hide warning, because error will be checked manually
if (false === @socket_bind($socket, '127.0.0.1', 60204)) {
    // some other process is already running
    SendcruxLog::warning('Another handling process is already running. Terminated!');
    exit;
}
Job::run();
